import serviceWorker from "@bluemind/commons.light/utils/service-worker";
import logger from "@bluemind/logger";
import session from "@bluemind/session";

declare const self: ServiceWorkerGlobalScope;

type MessageEventCallback<T extends string, K> = (
    body: any,
    headers: Record<string, string>,
    ev: MessageEvent<T, K>
) => void;

interface MessageEvent<T extends string, K> extends ExtendableMessageEvent {
    data: {
        type: T;
        body: K;
    };
}
export interface MessageHandler<T extends string, K = undefined> {
    type: T;
    callback: MessageEventCallback<T, K>;
}

export default {
    register<T extends string, K>(handler: MessageHandler<T, K>) {
        logger.log("[SW]Register handler for " + handler.type);
        serviceWorker.addMessageListener(handler.type, async (body, headers, event) => {
            if (headers.sid) {
                await session.sync(headers?.sid);
            }
            handler.callback(body, headers, event as MessageEvent<T, K>);
        });
    }
};
